﻿var editLongTable = {
    context: $(".v-edit-longtables"),
    allowedFormatExtensions: null,
    fileName: "",
    sheetName: null,
    selectedSqlDatabase: null,
    selectedSqlTable: null,
    initialize: function () {
        $("#Project", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSqlDatabasesForAutoComplete", "MultiMode", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#ProjectId")
        });

        if (importTypeFormat == Enum.LongTableImportFrom.Sql) {
            editLongTable.initializeSql();
        }
        else if (importTypeFormat == Enum.LongTableImportFrom.Excel) {
            editLongTable.initializeExcel();
        }
        else if (importTypeFormat == Enum.LongTableImportFrom.Access) {
            editLongTable.initializeAccess();
        }
    },
    initializeSql: function () {
        editLongTable.selectedSqlDatabase = $("#LtSqlModel_Database", editLongTable.context).val() || null;
        editLongTable.selectedSqlTable = $("#LtSqlModel_Table", editLongTable.context).val() || null;

        $(".h-sqlDatabases-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSqlDatabasesForAutoComplete", "MultiMode", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtSqlModel_SelectedDatabase"),
            select: function (event, data) {
                editLongTable.selectedSqlDatabase = data.item.Name;

                $(".h-sqlDatabaseTables-autocomplete", editLongTable.context).a4autocomplete("enable");
                $(".h-sqlDatabaseTables-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: { sqlDatabaseName: editLongTable.selectedSqlDatabase } });
            }
        });

        $(".h-sqlDatabaseTables-autocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSqlDatabaseTablesNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: { sqlDatabaseName: editLongTable.selectedSqlDatabase },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtSqlModel_SelectedTable"),
            select: function (event, data) {
                $(".h-sqlFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("clearValue");
                $(".h-sqlFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("clearValue");

                if (data.item.Name) {
                    editLongTable.selectedSqlTable = data.item.Name;

                    var params = {
                        sqlDatabaseName: editLongTable.selectedSqlDatabase,
                        sqlTableName: editLongTable.selectedSqlTable
                    };

                    $(".h-sqlFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("enable");
                    $(".h-sqlFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: params });

                    $(".h-sqlFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("enable");
                    $(".h-sqlFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: params });
                }
                else {
                    $(".h-sqlFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("disable");
                    $(".h-sqlFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("disable");
                }
            }
        });

        var fieldMappingParams = {
            sqlDatabaseName: editLongTable.selectedSqlDatabase,
            sqlTableName: editLongTable.selectedSqlTable
        };

        $(".h-sqlFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSqlTableColumnsNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: fieldMappingParams,
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtSqlModel_FieldMapping_SelectedCode")
        });

        $(".h-sqlFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSqlTableColumnsNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: fieldMappingParams,
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtSqlModel_FieldMapping_SelectedLabel")
        });

        if (editLongTable.selectedSqlDatabase == null)
            $(".h-sqlDatabaseTables-autocomplete", editLongTable.context).a4autocomplete("disable");

        if (editLongTable.selectedSqlTable == null)
        {
            $(".h-sqlFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("disable");
            $(".h-sqlFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("disable");
        }
    },
    initializeExcel: function () {
        $(".h-workbook-autocomplete", editLongTable.context).a4autocomplete({
            ajaxAction: a4.getAction("GetExcelWorksheetsNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: { fileName: editLongTable.fileName },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtExcelModel_SelectedWorkBook"),
            select: function (event, data) {
                $(".h-fieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("clearValue");
                $(".h-fieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("clearValue");

                if (data.item.Name) {
                    editLongTable.sheetName = data.item.Name;

                    var params = {
                        fileName: editLongTable.fileName,
                        sheetName: editLongTable.sheetName,
                        useFirstLineAsColumnHeader: $(".v-useFirstLineAsColumnHeader", editLongTable.context).is(':checked')
                    };

                    $(".h-fieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("enable");
                    $(".h-fieldmappingCode-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: params });

                    $(".h-fieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("enable");
                    $(".h-fieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: params });
                }
                else {
                    $(".h-fieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("disable");
                    $(".h-fieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("disable");
                }
            }
        });

        editLongTable.sheetName = $("#LtExcelModel_Workbook", editLongTable.context).val() || null;

        var fieldMappingParams = {
            fileName: editLongTable.fileName,
            sheetName: editLongTable.sheetName,
            useFirstLineAsColumnHeader: $(".v-useFirstLineAsColumnHeader", editLongTable.context).is(':checked')
        };

        $(".h-fieldmappingCode-autocomplete", editLongTable.context).a4autocomplete({
            ajaxAction: a4.getAction("GetExcelWorkbookColumnsNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: fieldMappingParams,
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtExcelModel_FieldMapping_SelectedCode")
        });

        $(".h-fieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete({
            ajaxAction: a4.getAction("GetExcelWorkbookColumnsNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: fieldMappingParams,
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtExcelModel_FieldMapping_SelectedLabel")
        });

        if (editLongTable.fileName == "")
        {
            $(".h-workbook-autocomplete", editLongTable.context).a4autocomplete("disable");
            $(".v-useFirstLineAsColumnHeader", editLongTable.context).attr("disabled", "disabled").prop("disabled", true);
        }

        if (editLongTable.sheetName == null)
        {
            $(".h-fieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("disable");
            $(".h-fieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("disable");
        }
    },
    initializeAccess: function () {
        $(".h-accesstable-autocomplete", editLongTable.context).a4autocomplete({
            ajaxAction: a4.getAction("GetAccessTablesNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: { fileName: editLongTable.fileName },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtExcelModel_SelectedWorkBook"),
            select: function (event, data) {
                $(".h-accessFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("clearValue");
                $(".h-accessFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("clearValue");

                if (data.item.Name) {
                    var params = {
                        fileName: editLongTable.fileName,
                        tableName: data.item.Name
                    };

                    $(".h-accessFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("enable");
                    $(".h-accessFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: params });

                    $(".h-accessFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("enable");
                    $(".h-accessFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: params });
                }
                else {
                    $(".h-accessFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("disable");
                    $(".h-accessFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("disable");
                }
            }
        });

        var selectedTable = $("#LtAccessModel_Table", editLongTable.context).val() || null;

        var fieldMappingParams = {
            fileName: editLongTable.fileName,
            tableName: selectedTable
        };

        $(".h-accessFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete({
            ajaxAction: a4.getAction("GetAccessColumnsNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: fieldMappingParams,
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtAccessModel_FieldMapping_SelectedCode")
        });

        $(".h-accessFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete({
            ajaxAction: a4.getAction("GetAccessColumnsNamesForAutoComplete", "MultiMode", "Settings"),
            ajaxParams: fieldMappingParams,
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#LtAccessModel_FieldMapping_SelectedLabel")
        });

        if (editLongTable.fileName == "")
            $(".h-accesstable-autocomplete", editLongTable.context).a4autocomplete("disable");

        if (selectedTable == null)
        {
            $(".h-accessFieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("disable");
            $(".h-accessFieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("disable");
        }
    },
    bindEvents: function () {
        editLongTable.context.on("change", "#Name", function () {
            var name = $(this).val().trim();

            if (name.replace(/^\s+|\s+$/g, "") != "" && name.replace(/^\s+|\s+$/g, "").toLowerCase().substring(0, 3) != "lt_")
                name = "LT_" + name.replace(/^\s+|\s+$/g, "");

            $(this).val(name);
        });

        editLongTable.context.on("change", ".v-useFirstLineAsColumnHeader", function () {
            var useFirstLineAsColumnHeader = $(this).is(':checked');

            var params = {
                fileName: editLongTable.fileName,
                sheetName: editLongTable.sheetName,
                useFirstLineAsColumnHeader: useFirstLineAsColumnHeader
            };

            $(".h-fieldmappingCode-autocomplete", editLongTable.context).a4autocomplete("clearValue");
            $(".h-fieldmappingCode-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: params});

            $(".h-fieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete("clearValue");
            $(".h-fieldmappingLabel-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: params });
        });
    },
}

var ltFileUpload = {
    container: null,
    uploadFields: null,
    uploadFieldModel: null,    
    initialize: function () {
        ltFileUpload.container = $("#fileUploadContainer");
        ltFileUpload.uploadFieldModel = $('<form class="file-upload-field h-fileUploadField"><input name="file" type="file" id="file"/><span class=\"v-allowedExtensions\"></span><span class="file-name v-fileName"></span>' + voxco.icons.getIcon("remove", "h-deleteFile delete-file-button") + voxco.icons.getIcon("loading", "upload-sample-spin") + '<div></div><span class=\"h-file-required new-item field-validation-valid\">' + resources.fileInputError + '</span></form>');

        if (editLongTable.fileName != "")
        {
            var uploadField = ltFileUpload.uploadFieldModel.clone();
            uploadField.find(".v-fileName").html(editLongTable.fileName);
            uploadField.attr("data-fname", editLongTable.fileName);
            uploadField.removeClass("uploading").addClass("uploaded");
            ltFileUpload.container.prepend(uploadField);
        }
        else
        {
            ltFileUpload.addNewUploadField();
        }
    },
    bindEvents: function () {
        ltFileUpload.container.on("change", ".h-fileUploadField input", function () {
            var uploadContainerForm = $(this).closest(".h-fileUploadField");
            var uploadFrameName = ("uploader" + (new Date()).getTime());
            var uploadFrame = $("<iframe name=\"" + uploadFrameName + "\" src=\"about:blank\" style=\"display: none;\" />");
            var filename = $(this).val().split('\\').pop();
            var extension = filename.split('.').pop();

            if (editLongTable.allowedFormatExtensions.indexOf(extension.toLowerCase()) > -1)
            {
                $("body").append(uploadFrame);
                uploadContainerForm.addClass("uploading");

                $(".v-fileName", uploadContainerForm).html(filename);
                ltFileUpload.uploadFile(uploadContainerForm, uploadFrame);
            }
            else
            {
                uploadContainerForm.remove();
                ltFileUpload.addNewUploadField();
                a4.showErrorMessage(resources.wrongFileExtension);
            }
        });

        ltFileUpload.container.on("click", ".h-deleteFile", function () {
            var uploadContainerForm = $(this).closest(".h-fileUploadField");
            var fileName = uploadContainerForm.attr("data-fname");

            if (fileName)
            {
                a4.callServerMethod(a4.getAction("DeleteLongTableFile", "MultiMode", "Settings"), { fileName: fileName },
                    function (result) {
                        $("#SourceFile", editLongTable.context).val("");
                        editLongTable.fileName = "";
                        editLongTable.sheetName = null;
                        editLongTable.selectedSqlDatabase = null;
                        editLongTable.selectedSqlTable = null;

                        $(".ui-autocomplete-input:not(#Project)", editLongTable.context).a4autocomplete("clearValue");
                        $(".ui-autocomplete-input:not(#Project)", editLongTable.context).a4autocomplete("disable");
                        $(".v-useFirstLineAsColumnHeader", editLongTable.context).attr("disabled", "disabled").prop("disabled", true);

                        uploadContainerForm.remove();
                        ltFileUpload.addNewUploadField();
                    }
                );
            }
        });
    },      
    addNewUploadField: function () {
        var uploadField = ltFileUpload.uploadFieldModel.clone();
        ltFileUpload.container.prepend(uploadField);

        if (editLongTable.allowedFormatExtensions)
            $(".v-allowedExtensions").html(" (" + editLongTable.allowedFormatExtensions.join(", ") + ")");

        if ($("#SourceFile", editLongTable.context).hasClass("input-validation-error"))
        {
            $("#fileUploadContainer").find(".h-file-required").removeClass("field-validation-valid");
            $("#fileUploadContainer").find(".h-file-required").addClass("field-validation-error");
            $("#fileUploadContainer").find(".h-file-required").removeClass("new-item");
        }
    },
    uploadFile: function (uploadContainerForm, uploadFrame) {
        $.ajax({
            type: "POST",
            url: a4.getAction("ImportLongTableFile", "MultiMode", "Settings"),
            headers: { "X-CSRF-TOKEN": $(aft).val() },
            data: new FormData($(".file-upload-field")[0]),
            cache: false,
            contentType: false,
            processData: false,
            success: function (result) {
                $("#SourceFile", editLongTable.context).val(result);
                editLongTable.fileName = result;

                uploadContainerForm.attr("data-fname", editLongTable.fileName);
                uploadContainerForm.find(".v-allowedExtensions").hide();

                uploadContainerForm.removeClass("uploading");
                uploadContainerForm.addClass("uploaded");

                $(".h-workbook-autocomplete", editLongTable.context).a4autocomplete("enable");
                $(".v-useFirstLineAsColumnHeader", editLongTable.context).attr("disabled", false).prop("disabled", false);
                $(".h-workbook-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: { fileName: editLongTable.fileName } });

                $(".h-accesstable-autocomplete", editLongTable.context).a4autocomplete("enable");
                $(".h-accesstable-autocomplete", editLongTable.context).a4autocomplete({ ajaxParams: { fileName: editLongTable.fileName } });

                if ($("#SourceFile", editLongTable.context).hasClass("input-validation-error"))
                {
                    $("#fileUploadContainer").find(".h-file-required").addClass("field-validation-valid");
                    $("#fileUploadContainer").find(".h-file-required").removeClass("field-validation-error");
                    $("#fileUploadContainer").find(".h-file-required").addClass("new-item");
                }

                setTimeout(function () { uploadFrame.remove(); }, 100);
            }
        });
    }
};

$(document).ready(function ()
{
    if (editLongTable.context.length > 0)
    {
        var id = $("#Id", editLongTable.context).val();

        if (typeof id === "undefined" || id == "0" || id == "")
        {
            editLongTable.fileName = $("#SourceFile", editLongTable.context).val().trim();

            editLongTable.initialize();
            editLongTable.bindEvents();

            editLongTable.allowedFormatExtensions = allowedFormatExtensions[importTypeFormat];

            if (importTypeFormat != Enum.LongTableImportFrom.Sql)
            {
                ltFileUpload.initialize();
                ltFileUpload.bindEvents();
            }
        }
        else
        {
            editLongTable.bindEvents();
        }
    }
});